unit KOLRuler;
//
// purpose: Simple ruler in centimeters, inches or pixels
//  author:  2004, Thaddy de Koning, copyrighted freeware
// remarks: Right click shows options menu
//          A very small portion is based on the freeware glruler.pas by Globus.
//          Bitmaps provided by Microsoft Corporation. (wordpad.cpp example)

interface
uses
  Windows, Messages, KOL,Richedit;

{$R kolruler.res}

type
  TSizeUnit = ( suCentimeters, suInches, suPixels );
  Torientation = (roHorizontal,roVertical);

  PRulerdata =^Trulerdata;
  TRulerData = object(Tobj)
  private
    FOwner:Pcontrol;
    Fmemo:pControl;
    FUp,
    FDown:Pbitmap;
    FMenu:PMenu;
    FFlag:Boolean;
    FUseUnit: TSizeUnit;
    LOGPIXELSX_,
    LOGPIXELSY_ : integer;
    Fold,
    FLeftPosition,
    FRightPosition: integer;
    procedure SetLeftPosition(const Value: integer);
    procedure SetRightPosition(const Value: integer);
  protected
    procedure Paint(sender:Pcontrol;DC:HDC);
    procedure DoRlPopup(sender:Pmenu;index:integer);
  public
    destructor destroy;virtual;
    property LeftRulerPosition: integer read FLeftPosition write SetLeftPosition;
    property RightRulerPosition: integer read FRightPosition write SetRightPosition;
    property Units: TSizeUnit read FUseUnit write FUseUnit
     default suCentimeters;
  end;

// Stand-alone version, programmer is responsible for behaveour.
function NewRuler(aOwner:Pcontrol;edgestyle:TEdgeStyle):Pcontrol;overload;

// Overloaded version: attaches to a Richedit control too, and
// provides automatic resizing based on the ruler positions
// The RichEdit's "Tag" property is used to store ruler information,
// so you won't be able to use it for other purposes.
function NewRuler(aOwner,aMemo:Pcontrol;Edgestyle:TEdgestyle):Pcontrol;overload;
function TwipsPerPixelX(DC:HDC) : Extended;
function TwipsPerPixelY(DC:HDC) : Extended;


implementation

function TwipsPerPixelX(DC:HDC) : Extended;
begin
  result := 1440 /
            GetDeviceCaps(DC,
            LOGPIXELSX);
end;

function TwipsPerPixelY(DC:HDC) : Extended;
begin
  result := 1440 /
            GetDeviceCaps(DC,
            LOGPIXELSY);
end;



function WndProcRuler( Sender: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
var
p:Tpoint;
begin
  Result:=False;
  with PRulerdata(sender.CustomObj)^do
  case msg.message of
  WM_LBUTTONDOWN:
    begin
      if HiWord(msg.Lparam) < sender.height div 2 then FFlag := true;
      if Assigned(Fmemo)then LockWindowUpdate(Fmemo.handle);
    end;
  WM_LBUTTONUP:
    begin
      FFlag := false;
      if Assigned(Fmemo)then LockWindowUpdate(0);
    end;
  WM_MOUSEMOVE:
     if (msg.wParam and MK_LBUTTON)>0 then
        begin
          begin
            if FFlag then
               SetLeftPosition(loword(msg.lParam))
            else
               SetRightPosition(loword(msg.lParam))
            end;
          Paint(sender, sender.canvas.handle);
          if assigned(Fmemo) then
          begin
            Fmemo.perform(WM_SIZE,0,0);
          end;
        end;
  WM_RBUTTONDOWN:
      begin
        P:=MakePoint(Loword(Msg.lparam),hiword(msg.lparam));
        Clienttoscreen(sender.Handle,P);
        Fmenu.Popup(p.x,p.y);
      end;
  else
  end;
end;


function WndProcRulerMemo( Sender: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
var
  Rect:Trect;
begin
   if Msg.message = WM_SIZE then
   begin
    // obtain current edit rectangle
    sender.Perform(EM_GETRECT,0,integer(@Rect));
    // set the new value
    Rect.Left:=PRulerData(sender.tag).LeftRulerPosition;
    Rect.Right:=PRulerData(sender.tag).RightRulerPosition;
    // set the new rectangle
    sender.Perform(EM_SETRECT,0,integer(@RECT));
   end;
   Result:=False;
end;

function NewRuler(aOwner:Pcontrol;edgestyle:Tedgestyle):Pcontrol;overload;
var data:PRulerData;
begin
  New(Data,Create);
  Result:=NewPanel(aOwner, edgestyle);
  Data.FMenu:=Newmenu(Result,0,['+!&Centimeters','-!&Inches','-!&Pixels'],data.DoRlPopup);
  Result.Height:=20;
  Result.CustomObj:=Data;
  Result.OnPaint:=Data.Paint;
  Result.AttachProc(WndProcRuler);
  Result.font.FontHeight:=-8;
  Result.Font.FontQuality:=fqAntialiased;
  Data.FLeftPosition:=6;
  Data.FRightPosition:=6 * 96;
  Data.FOwner:=Result;
  data.Units:=suCentimeters;
  data.FLeftPosition:=5;
  data.FUp:=NewBitmap(9,8);
  data.Fup.LoadFromResourceName(hInstance,'RUP');
  data.Add2AutoFree(data.Fup);
  data.FDown:=NewBitmap(9,8);
  data.FDown.LoadFromResourceName(hInstance,'RDO');
  data.Add2AutoFree(data.Fdown);
end;

function NewRuler(aOwner, aMemo:Pcontrol;edgestyle:TEdgestyle):Pcontrol;overload;
begin
  Result:=NewRuler(aOwner,edgestyle);
  PRulerdata(Result.CustomObj).FMemo:=aMemo;
  aMemo.tag:=Cardinal(Result.CustomObj);
  aMemo.AttachProc(WndProcRulerMemo);
end;



destructor TRulerData.destroy;
begin
 FOwner.DetachProc(WndProcRuler);
 inherited destroy;
end;

procedure TRulerData.DoRlPopup(sender: Pmenu; index: integer);
begin
  case index of
   0:Units:=suCentimeters;
   1:Units:=suInches;
   2:Units:=suPixels;
  end;
  Fowner.Invalidate;
end;

procedure TRulerdata.Paint(sender:Pcontrol;DC:HDC);
const
  Offset: array[boolean] of integer = ( 4, 6 );
var
  x, y: single;
  pt: TPoint;
  str: string;
  R,M: TRect;
  Fnt:THandle;
begin
  with sender.canvas^ do
  begin
    M:=Sender.ClientRect;
    brush.color:=clBtnFace;
    fillrect(M);
    brush.color:=clBtnHighlight;
    fillrect(MakeRect(m.Left,m.bottom div 2 - 1, m.right,m.bottom div 2));
    brush.color:=clBtnShadow;
    fillrect(MakeRect(m.left,m.bottom div 2, m.right,m.bottom div 2 + 1));
    LOGPIXELSX_ := GetDeviceCaps(DC,LOGPIXELSX);
    LOGPIXELSY_ := GetDeviceCaps(DC,LOGPIXELSY);
    Fnt:=sender.font.Handle;
    selectObject(DC,Fnt);
    x := 0; y := 0;

    repeat
    {Partially based on a bit of code from GlRuler.pas by Globus}
    x := x + 0.5 ; y := y + 0.5 ;
    case FUseUnit of
      suCentimeters:
      begin
        // pt.x := round( x * LOGPIXELSX_ * 0.254 * 1.541);
        // pt.y := round( y * LOGPIXELSY_ * 0.254 * 1.541);
        pt.x := round( x * LOGPIXELSX_ / 2.54);
        pt.y := round( y * LOGPIXELSY_  / 2.54);
      end;
      suInches:
      begin
        // pt.x := round( x * LOGPIXELSX_ * 1.541);
        // pt.y := round( y * LOGPIXELSY_ * 1.541);
        pt.x := round( x * LOGPIXELSX_ ) ;
        pt.y := round( y * LOGPIXELSY_ ) ;

      end;
      suPixels:
      begin
        pt.x := round( x * 50 );
        pt.y := round( y * 50 );
      end;
    end;
    if pt.x > sender.Width then break;
    if x = trunc(x) then
    begin
      R := MakeRect( pt.x-10, 0, pt.x+10, sender.Height);
      SetBkMode( DC, TRANSPARENT );
      if Units = suPixels then str := Int2Str(pt.x) else str := Int2Str(trunc(X));
      windows.DrawText( DC, PChar(str), Length(str), R, DT_SINGLELINE or DT_CENTER );
    end;
    MoveTo(pt.x, sender.height div 2 + Offset[x = trunc(x)]);
    LineTo( pt.x, sender.Height div 2 +1 );
    until false;

    FDown.DrawTransparent(DC,LeftRulerPosition-4,m.top, clBlack);
    FUp.DrawTransparent(DC,RightRulerPosition-4,m.bottom-Fup.height,clBlack);
  end;
end;

procedure TRulerData.SetLeftPosition(const Value: integer);
begin
  Fold:=FLeftposition;
  if FLeftPosition = Value then exit;
  FLeftPosition := Max(Fowner.Clientrect.left,Min(Fowner.clientwidth,Value));
  if FleftPosition >= FrightPosition then Swap(FleftPosition,FRightPosition);
end;

procedure TRulerData.SetRightPosition(const Value: integer);
begin
  Fold:=FRightposition;
  if FRightPosition = Value then exit;
  FRightPosition := Max(FOwner.ClientRect.left,Min(FOwner.clientwidth,Value));
  if FleftPosition >= FrightPosition then Swap(FleftPosition,FRightPosition);
end;

end.
